#!/usr/bin/env python3
# coding=utf-8

"""
config logger
"""

import os.path
import logging

from logging.config import fileConfig
from importlib.resources import files


def load_logger_config():
    """if /var/log/{{name}} exist, load default logger.conf.

    otherwise, try to create it directly.
    if that fails, try to create it with sudo.
    if that fails, use basic logger config.

    """
    logdir = "/var/log/{{name}}/"
    if os.path.exists(logdir):
        fileConfig(files("{{python-pkg-name}}").joinpath("logger.conf"))
        return

    ENV = os.getenv("ENV", "test")
    level = logging.INFO if ENV == "prod" else logging.DEBUG
    logging.basicConfig(
        format='%(asctime)s [%(module)s] %(levelname)-8s %(message)s',
        level=level)
    logging.info("Create log dir %s failed. Using basic config, level=%s",
                 logdir, level)


logging.captureWarnings(True)
load_logger_config()
