#!/usr/bin/env python
# coding=utf-8

"""
fabric file for server automation.
"""
# pylint: disable=line-too-long

import os.path
from fabric.api import env, sudo, run, local, hosts, put, cd

env.use_ssh_config = True
PROD_HOST = 'de01'


def get_version_from_setup_file():
    """parse version info from setup.py file.

    Return the version string.

    """
    with open("setup.py", "r") as f:
        for line in f:
            if "version=" in line:
                return line.split("=")[1][1:-3]
    raise Exception("version not found in setup.py")


@hosts(PROD_HOST)
def deploy():
    version = get_version_from_setup_file()
    deb_file = "{{name}}_%s_amd64.deb" % (version,)
    if not os.path.exists(deb_file):
        local("make deb")
    put(deb_file)
    run("dpkg -i %s" % (deb_file,))
