#!/usr/bin/env python
# coding=utf-8

"""
python distribute file
"""

from __future__ import (absolute_import, division, print_function,
                        unicode_literals, with_statement)

from setuptools import setup, find_packages


def requirements_file_to_list(fn="requirements.txt"):
    """read a requirements file and create a list that can be used in setup.

    """
    with open(fn, 'r') as f:
        return [x.rstrip() for x in list(f) if x and not x.startswith('#')]


setup(
    name="{{name}}",
    version="0.1.0",
    packages=find_packages(),
    install_requires=requirements_file_to_list(),
    dependency_links=[
        "https://emacsos.com/python/packages/"
    ],
    entry_points={
        # 'console_scripts': [
        #     'main = {{python-pkg-name}}.main:main',
        # ]
    },
    package_data={
        '{{python-pkg-name}}': ['logger.conf']
    },
    author="Yuanle Song",
    author_email="sylecn@gmail.com",
    maintainer="Yuanle Song",
    maintainer_email="sylecn@gmail.com",
    description="FIXME add description",
    long_description=open('README.rst').read(),
    license="GPLv2+",
    url="https://pypi.python.org/pypi/{{name}}",
    classifiers=[
        'Development Status :: 3 - Alpha',
        'License :: OSI Approved :: GNU General Public License (GPL)',
        'License :: OSI Approved :: GNU General Public License v2 or later (GPLv2+)',
        # 'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3.4',
    ]
)
