#!/usr/bin/env python
# coding=utf-8

"""
choose a default python command for creating virtualenv.

Current preferences is:
python in /home dir > /opt dir > /usr dir
prefer python3 over python2.7,

"""

from __future__ import print_function

import os


def first_existing_file(files):
    """return the first existing file in given list.

    """
    for f in files:
        if os.path.exists(os.path.expanduser(f)):
            return f


def main():
    print(first_existing_file([
        "~/bin/python3",
        "~/bin/python2.7",
        "~/bin/python",
        "~/opt/bin/python3",
        "~/opt/bin/python2.7",
        "/opt/python3.5/bin/python",
        "/usr/bin/python3",
        "/opt/python2.7/bin/python",
        "/usr/bin/python2.7",
        "/usr/bin/python",
    ]))


if __name__ == '__main__':
    main()
