module MbackupTests

open NUnit.Framework
open Mbackup

[<SetUp>]
let Setup () =
    ()

[<Test>]
let TestDumb () =
    Assert.Pass()

[<Test>]
let TestToMingwPath () =
    Assert.That("/cygdrive/c/", Is.EqualTo(ToMingwPath "c:\\"))
    Assert.That("/cygdrive/c/", Is.EqualTo(ToMingwPath "C:\\"))
    Assert.That("/cygdrive/c/foo", Is.EqualTo(ToMingwPath "C:\\foo"))
    Assert.That("/cygdrive/d/foo", Is.EqualTo(ToMingwPath "D:\\foo"))
    Assert.That("/cygdrive/d/Foo", Is.EqualTo(ToMingwPath "D:\\Foo"))
    Assert.That("/cygdrive/c/foo/bar/", Is.EqualTo(ToMingwPath "C:\\foo\\bar\\"))
    Assert.That("/cygdrive/c/foo/bar/baz.txt", Is.EqualTo(ToMingwPath "C:\\foo\\bar\\baz.txt"))
    Assert.That("/cygdrive/c/foo", Is.EqualTo(ToMingwPath "C:/foo"))
    Assert.That("/cygdrive/c/foo/bar", Is.EqualTo(ToMingwPath "C:/foo/bar"))
    Assert.That("/cygdrive/c/foo", Is.EqualTo(ToMingwPath "/c/foo"))
    Assert.That("/cygdrive/D/foo", Is.EqualTo(ToMingwPath "/D/foo"))
    Assert.That("/var/log", Is.EqualTo(ToMingwPath "/var/log"))
