﻿// Copyright (C) 2019  Yuanle Song <root@emacsos.com>
//
// This file is part of mbackup-for-windows.
//
// mbackup-for-windows is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by the
// Free Software Foundation, either version 3 of the License, or (at your
// option) any later version.
//
// mbackup-for-windows is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
// or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
// more details.
//
// You should have received a copy of the GNU General Public License along with
// mbackup-for-windows.  If not, see <http://www.gnu.org/licenses/>.

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace mbackupw
{
    /**
     * This is a winforms application used to invoke mbackup.exe without showing cmd.exe window.
     * This application is invoked by schtasks to run mbackup regularly.
     */
    public partial class Form1 : Form
    {
        private Timer exitTimer;
        // https://docs.microsoft.com/en-us/windows/win32/winmsg/extended-window-styles
        private const int WS_EX_NOACTIVATE = 0x08000000;
        private const int EXIT_TIMEOUT = 2;

        protected override CreateParams CreateParams
        {
            get
            {
                CreateParams createParams = base.CreateParams;
                createParams.ExStyle |= WS_EX_NOACTIVATE;
                return createParams;
            }
        }

        protected override bool ShowWithoutActivation
        {
            get { return true; }
        }

        private static void ExitTimerHandler(Object timer, EventArgs eventArgs)
        {
            Application.Exit();
        }

        private void ExitInNSeconds(int n)
        {
            exitTimer = new Timer();
            exitTimer.Tick += new EventHandler(ExitTimerHandler);
            exitTimer.Interval = n * 1000;
            exitTimer.Start();
        }

        private void RunMbackup()
        {
            string programFilesDir = Environment.GetFolderPath(Environment.SpecialFolder.ProgramFiles);
            string mbackupExe = programFilesDir + "\\mbackup\\publish\\mbackup.exe";
            int timeoutSeconds = 4 * 3600;
            ProcessStartInfo startInfo = new ProcessStartInfo {
                FileName = mbackupExe,
                Arguments = "",
                CreateNoWindow = true
            };
            Process proc = Process.Start(startInfo);
            if (proc.WaitForExit(timeoutSeconds * 1000)) {
                Environment.ExitCode = proc.ExitCode;
            } else {
                Environment.ExitCode = EXIT_TIMEOUT;
                proc.Kill();
            }
            Application.Exit();
            Environment.Exit(Environment.ExitCode);
        }

        public Form1()
        {
            InitializeComponent();
            // Hide form
            Opacity = 0;
            ShowInTaskbar = false;
            RunMbackup();
            // auto exit. just used for easier testing.
            // ExitInNSeconds(2);
        }
    }
}
