mbackup for windows
====================

Intro
------
mbackup is a file backup tool based on [rsync](https://rsync.samba.org/).
It supports backup a list of files and dirs to local dir or remote ssh node.

Difference with rsync: rsync doesn't have an official windows build.  rsync
doesn't support windows style path in source, target, and file lists.  You can
run rsync in cygwin or msys2 shell. But usually it's painful to run it in
windows cmd or powershell directly. Mbackup is a thin wrapper around rsync,
with support for windows style path and bundled openssh client.

Installation
-------------

mbackup is written in F# and C# in dotnet core 3.

To install mbackup, get .NET Core Installer and .NET Core Desktop Installer
from [dotnet core 3](https://dotnet.microsoft.com/download/dotnet-core/3.0)
and install both.

Get mbackup msi installer from
https://emacsos.com/software/mbackup-for-windows and run it. I don't have a
key to sign the exe, you should verify sha256sum if you worry about file
integrity.

Backup List and Exclude lists
------------------------------
By default, the following files are backed up by mbackup:

   - C:\ProgramData\mbackup
   - C:\Docs
   - D:\Docs
   - <User>\Documents
   - <User>\Desktop
   - <User>\Downloads
   - <User>\Pictures\Saved Pictures\
   - <User>\<dot files>

By default, some files are ignored, such as iso, rar, zip, exe etc. mbackup is
designed to backup user created contents, not downloaded contents. That's why
archives and executables are excluded by default.

You can add more dirs to backup in %programdata%\mbackup\local-list.txt

Here are the backup list files and exclude pattern files:

   - backup file list
     %programdata%\mbackup\default-list.txt
     %programdata%\mbackup\user-default-list.txt
     %programdata%\mbackup\local-list.txt (managed by user)

   - exclude pattern
     %programdata%\mbackup\default-exclude.txt
     %programdata%\mbackup\local-exclude.txt (managed by user)

local-list.txt and local-exclude.txt are managed by user and mbackup will not
modify those files when it is uninstalled or upgraded. The other lists are
shipped with mbackup and will be removed/overwritten when
uninstalling/upgrading mbackup.

To learn more about file list and exclude patterns, read rsync man page
https://download.samba.org/pub/rsync/rsync.html --files-from option,
--exclude-from option, and INCLUDE/EXCLUDE PATTERN RULES section.

How to Invoke mbackup
----------------------

mbackup for windows is designed to run automatically in the background via
Windows Task Scheduler (Win+R taskschd.msc). You can also run in from windows
cmd or powershell to trigger a backup immediately.

For the automatic backup to work, you need to specify a target in mbackup
config file.

Open mbackup config file %programdata%\mbackup\mbackup-config.txt,

To backup to local disk, add config

    target=D:\backup

Replace D:\backup with the dir you want to save backup files to.

To backup to remote ssh node, add config

    target=user@somehost.example.com:/path/to/dir
    ssh-key=D:\path\to\id_rsa

Replace ssh-key path with your ssh private key. Since mbackup is designed to
run in the background, only ssh key based authentication (with no passphrase)
is supported. If you use password to login your server, you may learn
[how to set up ssh keys](https://www.digitalocean.com/community/tutorials/how-to-set-up-ssh-keys--2).

Save mbackup-config.txt file, now auto backup will work. The default scheduler
runs mbackup a few minutes after user logon and every 2 hours during
daytime. You can open Task Scheduler to check the scheduler.

Here is how to run it in cmd or powershell:

    %programfiles%\mbackup\publish\mbackup.exe --help
	%programfiles%\mbackup\publish\mbackup.exe

You can also drag the mbackup shortcut to cmd window:

    C:\Users\Public\Desktop\mbackup.lnk --help
    C:\Users\Public\Desktop\mbackup.lnk

You can also click mbackup.exe shortcut on desktop or start menu. The downside
is the window will auto close after mbackup finishes.

You can check mbackup run log in %localappdata%\mbackup\mbackup.log

License
--------

Copyright (C) 2019  Yuanle Song <sylecn@gmail.com>

This file is part of mbackup-for-windows.

mbackup-for-windows is free software: you can redistribute
it and/or modify it under the terms of the GNU General
Public License as published by the Free Software Foundation,
either version 3 of the License, or (at your option) any
later version.

mbackup-for-windows is distributed in the hope that it will
be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.  See the GNU General Public License for
more details.

You should have received a copy of the GNU General Public
License along with this program.  If not, see
<https://www.gnu.org/licenses/>.
