module MbackupTests

open NUnit.Framework
open Mbackup.Lib
open Mbackup.Program

[<SetUp>]
let Setup () =
    ()

[<Test>]
let TestDumb () =
    Assert.Pass()

[<Test>]
let TesttoMingwPath () =
    Assert.That("/cygdrive/c/", Is.EqualTo(toMingwPath "c:\\"))
    Assert.That("/cygdrive/c/", Is.EqualTo(toMingwPath "C:\\"))
    Assert.That("/cygdrive/c/foo", Is.EqualTo(toMingwPath "C:\\foo"))
    Assert.That("/cygdrive/d/foo", Is.EqualTo(toMingwPath "D:\\foo"))
    Assert.That("/cygdrive/d/Foo", Is.EqualTo(toMingwPath "D:\\Foo"))
    Assert.That("/cygdrive/c/foo/bar/", Is.EqualTo(toMingwPath "C:\\foo\\bar\\"))
    Assert.That("/cygdrive/c/foo/bar/baz.txt", Is.EqualTo(toMingwPath "C:\\foo\\bar\\baz.txt"))
    Assert.That("/cygdrive/c/foo", Is.EqualTo(toMingwPath "C:/foo"))
    Assert.That("/cygdrive/c/foo/bar", Is.EqualTo(toMingwPath "C:/foo/bar"))
    Assert.That("/cygdrive/c/foo", Is.EqualTo(toMingwPath "/c/foo"))
    Assert.That("/cygdrive/D/foo", Is.EqualTo(toMingwPath "/D/foo"))
    Assert.That("/var/log", Is.EqualTo(toMingwPath "/var/log"))

[<Test>]
let TesttoWinPath () =
    Assert.That("C:\\abc\\def", Is.EqualTo(toWinPath "/cygdrive/c/abc/def"))
    Assert.That("C:\\abc\\def\\", Is.EqualTo(toWinPath "/cygdrive/c/abc/def/"))
    Assert.That("C:\\", Is.EqualTo(toWinPath "/cygdrive/c/"))
    Assert.That("D:\\", Is.EqualTo(toWinPath "/cygdrive/d/"))
    Assert.That(null, Is.EqualTo(toWinPath "/etc/foo/"))

let mysprintf fmt = sprintf fmt

[<Test>]
let TestMyprintf () =
  Assert.That("123", Is.EqualTo(mysprintf "123"))
  Assert.That("123", Is.EqualTo(mysprintf "%d" 123))
  Assert.That("123 456", Is.EqualTo(mysprintf "%d %d" 123 456))

let mylogger fmt =
  let doAfter s =
    "INFO " + s
  Printf.ksprintf doAfter fmt

[<Test>]
let TestMylogger () =
  Assert.That("INFO 123", Is.EqualTo(mylogger "123"))
  Assert.That("INFO 123", Is.EqualTo(mylogger "%d" 123))
  Assert.That("INFO 123 456", Is.EqualTo(mylogger "%d %d" 123 456))
  Assert.That("INFO 123 456 a", Is.EqualTo(mylogger "%d %d %s" 123 456 "a"))

[<Test>]
let TestStringSplit () =
  let r = "a=b".Split('=')
  Assert.That("a", Is.EqualTo(r.[0]))
  Assert.That("b", Is.EqualTo(r.[1]))
  let r = "a= b".Split('=')
  Assert.That("a", Is.EqualTo(r.[0]))
  Assert.That(" b", Is.EqualTo(r.[1]))
  let r = "a=b=c".Split('=', 2)
  Assert.That("a", Is.EqualTo(r.[0]))
  Assert.That("b=c", Is.EqualTo(r.[1]))

[<Test>]
let TestIsLocalTarget () =
  Assert.That(isLocalTarget("D:\\backup"))
  Assert.That(isLocalTarget("d:\\backup"))
  Assert.That(isLocalTarget("C:\\backup"))
  Assert.That(isLocalTarget("d:/backup"))
  Assert.That(isLocalTarget("D:/backup"))
  Assert.That(isLocalTarget("F:\\mbackup"))
  Assert.That(isLocalTarget("/cygdrive/d/backup"))
  Assert.That(isLocalTarget("/d/backup"))
