#ifndef _SQLITE3_UTIL_H_
#define _SQLITE3_UTIL_H_

#include <sqlite3.h>
#include <glib.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
 * execute sql on sqlite3 db using sqlite3_exec().
 *
 * Returns: TRUE on success, FALSE otherwise. if FALSE, errmsg will be printed
 * with g_warning().
 */
gboolean sqlite3_exec_simple (sqlite3 *db, const char *sql);

/**
 * copy src_dbname to dest_dbname using sqlite3_backup_step().
 *
 * dest and src should be opened sqlite3 db handler.
 * dest_dbname and src_dbname are db (schema) names.
 *
 * Returns: TRUE on success, FALSE otherwise.
 */
gboolean sqlite3_copy_db (sqlite3 *dest, const char* dest_dbname,
			  sqlite3 *src, const char* src_dbname);


#ifdef __cplusplus
}
#endif

#endif /* _SQLITE3_UTIL_H_ */
