#include <iostream>
#include <cstring>
#include "../PinyinArray.h"
#include "../PinyinParser.h"

#include "pinyin_parser.h"

void
parse(const char* pinyin, PinyinIndex* pi)
{
	if (pi == NULL) return;
	PyZy::PinyinArray pyar = {0};
	PyZy::PinyinParser::parse(pinyin, strlen(pinyin), 0, pyar, 1);
	if (pyar.size()) {
		pi->shengmu_i = (int) pyar[0].pinyin->pinyin_id[0].sheng;
		pi->yunmu_i = (int) pyar[0].pinyin->pinyin_id[0].yun;
	} else {
		pi->shengmu_i = -1;
		pi->yunmu_i = -1;
	}
}
