#include <glib.h>
#include "pinyin_parser.h"

static void
test_parse ()
{
	PinyinIndex pi = {-1, -1};
	parse("song", &pi);
	g_assert_cmpint (pi.shengmu_i, ==, 16);
	g_assert_cmpint (pi.yunmu_i, ==, 45);

	parse("s", &pi);
	g_assert_cmpint (pi.shengmu_i, ==, -1);
	g_assert_cmpint (pi.yunmu_i, ==, -1);

	parse("pian", &pi);
	g_assert_cmpint (pi.shengmu_i, ==, 13);
	g_assert_cmpint (pi.yunmu_i, ==, 36);

	parse("hua", &pi);
	g_assert_cmpint (pi.shengmu_i, ==, 7);
	g_assert_cmpint (pi.yunmu_i, ==, 48);
}

int
main (int argc, char *argv[])
{
	g_test_init (&argc, &argv, NULL);
	g_test_add_func ("/parse",
			 test_parse);

	return g_test_run ();
}
