#include <iostream>
#include <cstring>
#include "../PinyinArray.h"
#include "../PinyinParser.h"

// this is the missing docstring for PyZy::PinyinParser::parse().
/**
 * parse:
 *
 * @pinyin    the pinyin string to parse. this can contain more than 1 pinyin.
 * @len       length of pinyin string
 * @option    flags to enable fuzzy pinyin and auto correction, see Const.h
 *            I am not sure about their meaning in parse process.
 * @result    parse result will be stored in this vector.
 *            Each parsed pinyin will be stored in a PinyinSegment.
 *            in each PinyinSegment,
 *              begin marks the start char index from @pinyin param.
 *              text, len, sheng, yun all marks this pinyin segment's property.
 *              pinyin pointer, kind of confusing, too many fields.
 *              I only know and use the pinyin_id[0] struct, which contains
 *              sheng and yun's index as char.
 *
 * @max parse at most these many pinyin segments.
 *
 * Returns: number of characters that are successfully parsed.
 */
// static size_t parse (const String &pinyin,
//                      size_t        len,
//                      unsigned int  option,
//                      PinyinArray  &result,
//                      size_t        max);

static inline void
print_parse_result(size_t result, PyZy::PinyinArray &pyar)
{
	std::cout << "result=" << result << std::endl;
	for (auto &segment : pyar) {
		std::cout << "begin=" << segment.begin << std::endl
			  << "len=" << segment.len << std::endl
			  << "Pinyin text=" << segment.pinyin->text
			  << " sheng=" << segment.pinyin->sheng
			  << " yun=" << segment.pinyin->yun << std::endl
			  << "  pinyin_id[0]={"
			  << (int) segment.pinyin->pinyin_id[0].sheng
			  << ","
			  << (int) segment.pinyin->pinyin_id[0].yun
			  << "}"
			  << " pinyin_id[1]={"
			  << (int) segment.pinyin->pinyin_id[1].sheng
			  << ","
			  << (int) segment.pinyin->pinyin_id[1].yun
			  << "}"
			  << " pinyin_id[2]={"
			  << (int) segment.pinyin->pinyin_id[2].sheng
			  << ","
			  << (int) segment.pinyin->pinyin_id[2].yun
			  << "}"
			  << std::endl;
	}
}

/**
 * run parse() on given pinyin and print result.
 */
static inline void
run_parse(const char* pinyin)
{
	PyZy::PinyinArray pyar = {0};
	size_t result = PyZy::PinyinParser::parse (
		pinyin, strlen (pinyin), 0, pyar, 15);
	print_parse_result (result, pyar);
}

int
main (int argc, char *argv[])
{
	run_parse ("song");
	run_parse ("suipianhua");
	return 0;
}
