#include <glib.h>
#include <sqlite3.h>

static void
test_string_escape ()
{
	const char* phrase1 = "nihao";
	char* quoted = sqlite3_mprintf("%Q", phrase1);
	g_assert_cmpstr (quoted, ==, "'nihao'");
	sqlite3_free (quoted);

	const char* phrase2 = "ni'hao";
	quoted = sqlite3_mprintf("%Q", phrase2);
	g_assert_cmpstr (quoted, ==, "'ni''hao'");
	sqlite3_free (quoted);
	
	const char* phrase3 = "'nihao'";
	quoted = sqlite3_mprintf("%Q", phrase3);
	g_assert_cmpstr (quoted, ==, "'''nihao'''");
	sqlite3_free (quoted);

	const char* phrase4 = "英国";
	quoted = sqlite3_mprintf("%Q", phrase4);
	g_assert_cmpstr (quoted, ==, "'英国'");
	sqlite3_free (quoted);

	const char* phrase5 = "英';drop国";
	quoted = sqlite3_mprintf("%Q", phrase5);
	g_assert_cmpstr (quoted, ==, "'英'';drop国'");
	sqlite3_free (quoted);
}

int
main (int argc, char *argv[])
{
	g_test_init (&argc, &argv, NULL);
	g_test_add_func ("/Database/string-escape",
			 test_string_escape);

	return g_test_run ();
}
